@extends('upgrade.layout')

@section('title', 'Rollback')
@section('subtitle', 'Restore previous version')

@section('content')
    <h2 style="margin-bottom: var(--spacing-lg); color: var(--white);">Rollback Upgrade</h2>
    
    <div id="rollbackConfirm">
        <p style="margin-bottom: var(--spacing-lg);">
            Rolling back will restore your application to its previous state before the upgrade was attempted.
        </p>
        
        <div class="info-card">
            <h3><i class="fas fa-history"></i> Backup Information</h3>
            
            <div class="info-item">
                <div class="info-label">Backup Name</div>
                <div class="info-value">{{ $backupName }}</div>
            </div>
            
            <div class="info-item">
                <div class="info-label">What will be restored</div>
                <div class="info-value">
                    <ul style="padding-left: var(--spacing-lg); margin: var(--spacing-xs) 0 0 0;">
                        <li style="margin-bottom: var(--spacing-xs);">Application files</li>
                        <li style="margin-bottom: var(--spacing-xs);">Configuration files</li>
                        <li style="margin-bottom: var(--spacing-xs);">Database</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div style="margin-top: var(--spacing-lg); background-color: rgba(255, 193, 7, 0.1); border-radius: var(--border-radius-md); padding: var(--spacing-lg); border: 1px solid rgba(255, 193, 7, 0.2);">
            <div style="display: flex; align-items: flex-start;">
                <i class="fas fa-exclamation-triangle" style="color: var(--warning); margin-right: var(--spacing-sm); margin-top: 3px;"></i>
                <div>
                    <p style="font-weight: 500; margin-bottom: var(--spacing-xs);">Warning</p>
                    <p style="font-size: 0.9rem; margin: 0;">
                        Rolling back will undo all changes made during the upgrade. Any data created or modified after the backup was made will be lost. This action cannot be undone.
                    </p>
                </div>
            </div>
        </div>
        
        <form action="{{ route('upgrade.do_rollback') }}" method="POST" id="rollbackForm" style="margin-top: var(--spacing-xl);">
            @csrf
        </form>
    </div>
    
    <div id="rollbackProgress" style="display: none;">
        <div style="text-align: center; margin-bottom: var(--spacing-xl);">
            <div class="loader" style="width: 48px; height: 48px; border-width: 4px; margin: 0 auto var(--spacing-lg);"></div>
            <h3 style="margin-top: var(--spacing-md); color: var(--white);">Rolling Back...</h3>
            <p id="progressText" style="margin-top: var(--spacing-sm); color: var(--light-gray);">Preparing rollback...</p>
        </div>
        
        <div style="background-color: var(--dark-gray); border-radius: var(--border-radius-md); overflow: hidden; height: 16px; margin-bottom: var(--spacing-md);">
            <div id="progressBar" style="width: 0%; height: 100%; background: linear-gradient(90deg, var(--warning), #ffd966); transition: width 0.5s ease;"></div>
        </div>
        
        <div style="text-align: center; color: var(--light-gray); font-size: 0.9rem;">
            <span id="progressPercent">0</span>% Complete
        </div>
        
        <div style="margin-top: var(--spacing-xl); background-color: rgba(255, 193, 7, 0.1); border-radius: var(--border-radius-md); padding: var(--spacing-md); border: 1px solid rgba(255, 193, 7, 0.2);">
            <div style="display: flex; align-items: flex-start;">
                <i class="fas fa-exclamation-triangle" style="color: var(--warning); margin-right: var(--spacing-sm); margin-top: 3px;"></i>
                <p style="font-size: 0.9rem; margin: 0;">
                    <strong>Please do not close this window.</strong> The rollback process is running.
                </p>
            </div>
        </div>
    </div>
    
    <div id="rollbackComplete" style="display: none;">
        <div class="completion-icon">
            <i class="fas fa-check-circle"></i>
        </div>
        
        <h3 style="text-align: center; color: var(--white); margin-bottom: var(--spacing-lg);">
            Rollback Completed Successfully!
        </h3>
        
        <p style="text-align: center; margin-bottom: var(--spacing-lg);">
            Your application has been restored to its previous state.
        </p>
        
        <div style="text-align: center;">
            <a href="{{ url('/') }}" class="btn btn-success">
                <i class="fas fa-home"></i> Go to Homepage
            </a>
        </div>
    </div>
    
    <div id="rollbackError" style="display: none;">
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i>
            <div>
                <strong>Rollback Failed</strong>
                <p id="errorMessage" style="margin-top: var(--spacing-xs);"></p>
            </div>
        </div>
        
        <div style="text-align: center; margin-top: var(--spacing-lg);">
            <a href="{{ route('upgrade.index') }}" class="btn">
                <i class="fas fa-home"></i> Go Back
            </a>
        </div>
    </div>
@endsection

@section('footer')
    <div id="confirmButtons">
        <a href="{{ route('upgrade.index') }}" class="btn">
            <i class="fas fa-times"></i> Cancel
        </a>
        <button type="submit" form="rollbackForm" class="btn btn-warning" id="rollbackBtn">
            <i class="fas fa-undo"></i> Confirm Rollback
        </button>
    </div>
    <div id="processingButtons" style="display: none;">
        <div></div>
        <div></div>
    </div>
@endsection

@section('scripts')
<script>
    let rollbackStarted = false;
    let pollInterval;
    
    document.getElementById('rollbackForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        if (!confirm('Are you sure you want to rollback? This will undo all upgrade changes.')) {
            return;
        }
        
        startRollback();
    });
    
    function startRollback() {
        if (rollbackStarted) return;
        rollbackStarted = true;
        
        document.getElementById('rollbackConfirm').style.display = 'none';
        document.getElementById('confirmButtons').style.display = 'none';
        document.getElementById('rollbackProgress').style.display = 'block';
        document.getElementById('processingButtons').style.display = 'flex';
        
        // Start polling progress
        pollInterval = setInterval(pollProgress, 1000);
        
        fetch('{{ route('upgrade.do_rollback') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            clearInterval(pollInterval);
            
            if (data.success) {
                document.getElementById('rollbackProgress').style.display = 'none';
                document.getElementById('rollbackComplete').style.display = 'block';
            } else {
                document.getElementById('rollbackProgress').style.display = 'none';
                document.getElementById('rollbackError').style.display = 'block';
                document.getElementById('errorMessage').textContent = data.message;
            }
        })
        .catch(error => {
            clearInterval(pollInterval);
            document.getElementById('rollbackProgress').style.display = 'none';
            document.getElementById('rollbackError').style.display = 'block';
            document.getElementById('errorMessage').textContent = 'An unexpected error occurred: ' + error.message;
        });
    }
    
    function pollProgress() {
        fetch('{{ route('upgrade.progress') }}')
            .then(response => response.json())
            .then(data => {
                const percent = data.percent || 0;
                const message = data.message || 'Processing...';
                
                document.getElementById('progressBar').style.width = percent + '%';
                document.getElementById('progressPercent').textContent = percent;
                document.getElementById('progressText').textContent = message;
            })
            .catch(error => {
                console.error('Failed to fetch progress:', error);
            });
    }
</script>
@endsection